//FloorMountingPosts.scad;

//Use FloorMountingPostUNO four times 
//to generate four mounting posts;

//FloorMountingPost generates one 
//mounting post centered at the origin, 
//resting on the XY plane and standing 
//vertically above that plane;

//I need six mounting posts,
//four for the PCB carrying 
//the XC4502 and the XC4512,
//and two for the PH9205 battery case;

include <BATT_Dimensions.scad>
use <BATT_FloorMountingPost.scad>;

module FloorMountingPosts()
{
      
echo("Begin FloorMountingPosts");
    
//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ -Fuzz;

//echo("Post1 = ", Post1x, Post1y);
translate([Post1x, Post1y, DeltaZ])
    FloorMountingPost();

//echo("Post2 = ", Post2x, Post2y);
translate([Post2x, Post2y, DeltaZ])
    FloorMountingPost();

//echo("Post3 = ", Post3x, Post3y);
translate([Post3x, Post3y, DeltaZ])
    FloorMountingPost();

//echo("Post4 = ", Post4x, Post4y);
translate([Post4x, Post4y, DeltaZ])
    FloorMountingPost();

//echo("Post5 = ", Post5x, Post5y);
translate([Post5x, Post5y, DeltaZ])
    FloorMountingPost();

//echo("Post6 = ", Post6x, Post6y);
translate([Post6x, Post6y, DeltaZ])
    FloorMountingPost();

}
//
